% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_i.R
\name{sd_i}
\alias{sd_i}
\title{Sample Standard Deviation for Integer Values}
\usage{
sd_i(x)
}
\arguments{
\item{x}{Integer vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[stats]{sd}} for integer vectors. Not valid for non-integer 
vectors.
}
\examples{
# For integer vectors, var_i is typically much faster than var.
x <- rpois(1000, lambda = 5)
all.equal(sd(x), sd_i(x))
benchmark(sd(x), sd_i(x), replications = 2000)

}
