% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{true_range_n}
\alias{true_range_n}
\title{True Range of Numeric Values}
\usage{
true_range_n(x)
}
\arguments{
\item{x}{Numeric vector or matrix.}
}
\value{
Numeric value.
}
\description{
Defined as the difference between the maximum and the minimum. Equivalent to 
base R code \code{diff(range(x))}, but much faster. For integer objects, 
\code{\link{true_range_i}} should run even faster.
}
\examples{
# In general, true_range_n is much faster than diff(range(x))
x <- rnorm(1000)
all.equal(diff(range(x)), true_range_n(x))
benchmark(diff(range(x)), true_range_n(x), replications = 5000)

# For integer vectors, true_range_i should be even faster
x <- rpois(1000, lambda = 5)
all.equal(diff(range(x)), true_range_i(x))
benchmark(diff(range(x)), true_range_n(x), true_range_i(x), 
          replications = 5000)

}
