% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_min_iv}
\alias{which_min_iv}
\title{Return Index of (First) Minimum of an Integer Vector}
\usage{
which_min_iv(x)
}
\arguments{
\item{x}{Integer vector.}
}
\value{
Integer value.
}
\description{
Written in C++, this function tends to run faster than 
\code{\link{which.min}} for large integer vectors.
}
\details{
For optimal speed, choose the version of this function that matches the 
class of your \code{x}:

\code{\link{which_min_nv}} for numeric vector. \cr
\code{\link{which_min_iv}} for integer vector. \cr
\code{\link{which_min_nm}} for numeric matrix. \cr
\code{\link{which_min_im}} for integer matrix.
}
\examples{
# For long vectors, which_min_iv is faster than which.min 
x <- rpois(10000, lambda = 15)
which.min(x) == which_min_iv(x)
benchmark(which.min(x), which_min_iv(x), replications = 5000)

# For shorter vectors, which_min_iv is slower than which.min
x <- rpois(100, lambda = 15)
which.min(x) == which_min_iv(x)
benchmark(which.min(x), which_min_iv(x), replications = 20000)

}
