% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dygraph.R
\name{dygraph}
\alias{dygraph}
\title{dygraph interactive plot for time series data}
\usage{
dygraph(data, main = NULL, xlab = NULL, ylab = NULL, periodicity = NULL,
  group = NULL, width = NULL, height = NULL)
}
\arguments{
\item{data}{Either time series data or numeric data. For time series, this
must be an \link[xts]{xts} object or an object which is convertible to
\code{xts}. For numeric data, this must be a named list or data frame,
where the first element/column provides x-axis values and all subsequent
elements/columns provide one or more series of y-values.}

\item{main}{Main plot title (optional)}

\item{xlab}{X axis label}

\item{ylab}{Y axis label}

\item{periodicity}{Periodicity of time series data (automatically detected
via \link[xts:periodicity]{xts::periodicity} if not specified).}

\item{group}{Group to associate this plot with. The x-axis zoom level of
plots within a group is automatically synchronized.}

\item{width}{Width in pixels (optional, defaults to automatic sizing)}

\item{height}{Height in pixels (optional, defaults to automatic sizing)}
}
\value{
Interactive dygraph plot
}
\description{
R interface to interactive time series plotting using the
\href{http://dygraphs.com}{dygraphs} JavaScript library.
}
\note{
See the \href{http://rstudio.github.io/dygraphs/}{online documentation} for
additional details and examples.
}
\examples{
library(dygraphs)
lungDeaths <- cbind(mdeaths, fdeaths)
dygraph(lungDeaths)

indoConc <- Indometh[Indometh$Subject == 1, c("time", "conc")]
dygraph(indoConc)
}

