/*
 * Decompiled with CFR 0.152.
 */
package dyn;

import drawing.Series;
import dyn.Graphe;
import ihm.Gestionnaire;
import ihm.Habilleur;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class NuagePoint
extends Graphe {
    public NuagePoint(Gestionnaire gest, Habilleur hab, String titreGraphe, String titreX, String titreY) {
        super(gest, hab, titreGraphe, titreX, titreY);
    }

    protected JFreeChart createChart(XYDataset dataset) {
        if (this.m_gestionnaire.getType() == 2) {
            return ChartFactory.createGroupPlot(this.getTitreGraphe(), this.getTitreX(), this.getTitreY(), dataset, this.getOrientation(), this.m_gestionnaire.isAffLegende(), false, false);
        }
        return ChartFactory.createScatterPlot(this.getTitreGraphe(), this.getTitreX(), this.getTitreY(), dataset, this.getOrientation(), this.m_gestionnaire.isAffLegende(), false, false);
    }

    protected XYDataset construireSeries() {
        this.setCanvas();
        this.m_data = new DefaultXYDataset();
        for (Series s : this.getDonnee()) {
            String cde = s.getSemantique();
            double[][] don = new double[2][s.getNbDonneeID()];
            int i = 0;
            int nb = 0;
            while (i < s.getNbDonneeID()) {
                if (!this.m_gestionnaire.isFantome(s.getDonneeID(i))) {
                    don[0][nb] = s.getDonneeID(i).getCoord(this.m_gestionnaire.getAxeX());
                    don[1][nb] = s.getDonneeID(i).getCoord(this.m_gestionnaire.getAxeY());
                    this.m_canvas.addPoint(s.getDonneeID(i));
                    ++nb;
                }
                ++i;
            }
            double[][] donF = new double[2][nb];
            int j = 0;
            while (j < nb) {
                donF[0][j] = don[0][j];
                donF[1][j] = don[1][j];
                ++j;
            }
            if (nb == 0) continue;
            ((DefaultXYDataset)this.m_data).addSeries((Comparable)((Object)cde), donF);
        }
        return this.m_data;
    }
}

