/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class BlendBiColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme firstScheme;
    private ColorScheme secondScheme;
    private double firstSchemeLikeness;

    public BlendBiColorScheme(ColorScheme firstScheme, ColorScheme secondScheme, double firstSchemeLikeness) {
        this.firstScheme = firstScheme;
        this.secondScheme = secondScheme;
        this.firstSchemeLikeness = firstSchemeLikeness;
        this.foregroundColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getForegroundColor(), secondScheme.getForegroundColor(), firstSchemeLikeness));
        this.mainUltraDarkColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getUltraDarkColor(), secondScheme.getUltraDarkColor(), firstSchemeLikeness));
        this.mainDarkColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getDarkColor(), secondScheme.getDarkColor(), firstSchemeLikeness));
        this.mainMidColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getMidColor(), secondScheme.getMidColor(), firstSchemeLikeness));
        this.mainLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getLightColor(), secondScheme.getLightColor(), firstSchemeLikeness));
        this.mainExtraLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getExtraLightColor(), secondScheme.getExtraLightColor(), firstSchemeLikeness));
        this.mainUltraLightColor = new Color(SubstanceColorUtilities.getInterpolatedRGB(firstScheme.getUltraLightColor(), secondScheme.getUltraLightColor(), firstSchemeLikeness));
        this.id = "Blended " + SubstanceCoreUtilities.getSchemeId(firstScheme) + " & " + SubstanceCoreUtilities.getSchemeId(secondScheme) + ":" + firstSchemeLikeness;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public double getFirstSchemeLikeness() {
        return this.firstSchemeLikeness;
    }

    public ColorScheme getFirstScheme() {
        return this.firstScheme;
    }

    public ColorScheme getSecondScheme() {
        return this.secondScheme;
    }
}

