/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceMosaicWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        int sqDim = 7;
        int sqGap = 2;
        int cellDim = sqDim + sqGap;
        int rows = height / cellDim;
        int columns = width / cellDim;
        for (int col = 0; col <= columns; ++col) {
            for (int row = 0; row <= rows; ++row) {
                double val = isPreview ? Math.abs(Math.sin(1 + col + columns * row)) : Math.random();
                int delta = isPreview ? (int)(150.0 * val) : (int)(10.0 * val);
                int alpha = 0;
                alpha = isPreview ? 50 + delta : (SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 10 + delta * 3 / 2 : 5 + delta);
                Color stampColor = null;
                if (isPreview) {
                    stampColor = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.lightGray : Color.darkGray;
                    stampColor = SubstanceColorUtilities.getAlphaColor(stampColor, alpha);
                } else {
                    stampColor = SubstanceColorUtilities.getWatermarkStampColor(alpha);
                }
                graphics.setColor(stampColor);
                graphics.fillRect(x + col * cellDim, y + row * cellDim, sqDim, sqDim);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return SubstanceMosaicWatermark.getName();
    }

    public static String getName() {
        return "Square mosaic";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }
}

