/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetOptions {
    protected String[] params;
    protected Vector pVector = null;
    protected Hashtable shortToLongMap = new Hashtable();
    protected Hashtable longToIsFlagMap = new Hashtable();
    protected Hashtable longToComment;
    protected Hashtable longToOptionsMap = new Hashtable();

    public GetOptions() {
        this.longToComment = new Hashtable();
        this.params = new String[0];
    }

    public void addOption(String longName, boolean flag) {
        this.longToIsFlagMap.put(longName, new Boolean(flag));
    }

    public void addOption(String longName, boolean flag, String comment) {
        this.longToIsFlagMap.put(longName, new Boolean(flag));
        this.longToComment.put(longName, comment);
    }

    public void addOption(char shortName, boolean flag) {
        this.addOption(new Character(shortName).toString(), shortName, flag);
    }

    public void addOption(char shortName, boolean flag, String comment) {
        this.addOption(new Character(shortName).toString(), shortName, flag, comment);
    }

    public void addOption(String longName, char shortName, boolean flag) {
        this.addOption(longName, shortName, flag, null);
    }

    public void addOption(String longName, char shortName, boolean flag, String comment) {
        this.shortToLongMap.put(new Character(shortName).toString(), longName);
        this.longToIsFlagMap.put(longName, new Boolean(flag));
        if (comment != null) {
            this.longToComment.put(longName, comment);
        }
    }

    public boolean isLegalOption(String longName) {
        return this.longToIsFlagMap.containsKey(longName);
    }

    public boolean hasOption(String longName) {
        return this.longToOptionsMap.containsKey(longName);
    }

    public String getOption(String longName) {
        return this.longToOptionsMap.get(longName).toString();
    }

    public String getComment(String longName) {
        if (this.longToComment.containsKey(longName)) {
            return this.longToComment.get(longName).toString();
        }
        return null;
    }

    public void dumpOptions() {
        System.out.println("Options:");
        System.out.println();
        System.out.println("Short Long         Value    Comment");
        System.out.println("Name  Name         Required");
        System.out.println("----- ------------ -------- ---------------------------");
        Enumeration vo = this.getValidOptions();
        while (vo.hasMoreElements()) {
            System.out.println(vo.nextElement());
        }
    }

    private Enumeration getValidOptions() {
        Enumeration shortNames = this.shortToLongMap.keys();
        Vector<String> v = new Vector<String>();
        String shortName = "";
        String longName = "";
        while (shortNames.hasMoreElements()) {
            shortName = shortNames.nextElement().toString();
            longName = this.shortToLongMap.get(shortName).toString();
            v.addElement(this.formElement(shortName, longName));
        }
        Enumeration longNames = this.longToIsFlagMap.keys();
        while (longNames.hasMoreElements()) {
            longName = longNames.nextElement().toString();
            if (this.shortToLongMap.containsKey(shortName)) continue;
            v.addElement(this.formElement(" ", longName));
        }
        return v.elements();
    }

    private String formElement(String shortName, String longName) {
        String valueReqd = (Boolean)this.longToIsFlagMap.get(longName) != false ? "no" : "yes";
        return this.pad(shortName, 5) + " " + this.pad(longName, 12) + " " + this.pad(valueReqd, 8) + " " + this.getComment(longName);
    }

    private String pad(String value, int length) {
        String padding = "                                                       ";
        int l = value.length();
        if (l == length) {
            return value;
        }
        if (l < length) {
            return value + padding.substring(0, length - l);
        }
        return value.substring(length);
    }

    public void parseArgs(String[] argv) throws BadArguments {
        try {
            int j;
            int i;
            block6: for (i = 0; i < argv.length; ++i) {
                Boolean isFlag;
                String longName;
                if (argv[i] == "-" || argv[i] == "--") {
                    ++i;
                    break;
                }
                if (argv[i].charAt(0) != '-') break;
                if (argv[i].charAt(1) == '-') {
                    longName = argv[i].substring(2);
                    try {
                        isFlag = (Boolean)this.longToIsFlagMap.get(longName);
                        if (!isFlag.booleanValue()) {
                            this.longToOptionsMap.put(longName, argv[++i]);
                            continue;
                        }
                        this.longToOptionsMap.put(longName, "FLAG");
                        continue;
                    }
                    catch (Exception e1) {
                        String exceptionMsg = this.isLegalOption(longName) ? "The " + longName + " option needs a different number of arguments than you provided." : "There is no long option called \"" + longName + "\".";
                        throw new BadArguments(exceptionMsg);
                    }
                }
                for (j = 1; j < argv[i].length(); ++j) {
                    String shortName = argv[i].substring(j, j + 1);
                    try {
                        longName = this.shortToLongMap.get(shortName).toString();
                        isFlag = (Boolean)this.longToIsFlagMap.get(longName);
                    }
                    catch (Exception e) {
                        throw new BadArguments("There is no short option called \"" + shortName + "\".");
                    }
                    if (isFlag == null) {
                        throw new BadArguments("There is no short option called \"" + shortName + "\".");
                    }
                    if (!isFlag.booleanValue()) {
                        if (j == argv[i].length() - 1) {
                            this.longToOptionsMap.put(longName, argv[++i]);
                            continue block6;
                        }
                        this.longToOptionsMap.put(longName, argv[i].substring(j + 1));
                        continue block6;
                    }
                    this.longToOptionsMap.put(longName, isFlag.toString());
                }
            }
            this.params = new String[argv.length - i];
            j = 0;
            while (i < argv.length) {
                this.params[j] = argv[i];
                ++i;
                ++j;
            }
        }
        catch (ArrayIndexOutOfBoundsException eek) {
            throw new BadArguments("The last option you specified requires a value and you did not provide one.");
        }
    }

    public String[] getParams() {
        if (this.pVector != null) {
            this.params = new String[this.pVector.size()];
            this.pVector.copyInto(this.params);
            this.pVector = null;
        }
        return this.params;
    }

    public String getParam(int pNum) {
        if (this.pVector != null) {
            this.params = new String[this.pVector.size()];
            this.pVector.copyInto(this.params);
            this.pVector = null;
        }
        return this.params[pNum];
    }

    public int numParams() {
        if (this.pVector == null) {
            return this.params.length;
        }
        return this.pVector.size();
    }

    public void addParam(String param) {
        if (this.pVector == null) {
            int capacity = this.params.length > 0 ? this.params.length : 5;
            this.pVector = new Vector(capacity, 5);
            for (int i = 1; i < this.params.length; ++i) {
                this.pVector.addElement(this.params[i]);
            }
        }
        this.pVector.addElement(param);
    }

    public static class BadArguments
    extends Exception {
        public BadArguments() {
        }

        public BadArguments(String s) {
            super(s);
        }
    }
}

