/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.scroll;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SimplisticSoftBorderGradientPainter;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceScrollPaneBorder
implements Border,
UIResource {
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JScrollPane scrollPane = (JScrollPane)c;
        JScrollBar vertical = scrollPane.getVerticalScrollBar();
        JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
        SimplisticSoftBorderGradientPainter painter = new SimplisticSoftBorderGradientPainter();
        ColorScheme scheme = SubstanceCoreUtilities.getDefaultScheme(c);
        if (scrollPane.getComponentOrientation().isLeftToRight()) {
            g.setColor(((StandardGradientPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (vertical.isVisible()) {
                g.drawLine(x, y, x + width - vertical.getWidth(), y);
            } else {
                g.drawLine(x, y, x + width, y);
            }
            g.setColor(((StandardGradientPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (horizontal.isVisible()) {
                g.drawLine(x, y, x, y + height - horizontal.getHeight());
            } else {
                g.drawLine(x, y, x, y + height);
            }
            g.setColor(((StandardGradientPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!horizontal.isVisible()) {
                if (vertical.isVisible()) {
                    g.drawLine(x, y + height - 1, x + width - vertical.getWidth(), y + height - 1);
                } else {
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g.setColor(((StandardGradientPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!vertical.isVisible()) {
                if (horizontal.isVisible()) {
                    g.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
                } else {
                    g.drawLine(x + width - 1, y, x + width - 1, y + height);
                }
            }
        } else {
            g.setColor(((StandardGradientPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (vertical.isVisible()) {
                g.drawLine(x + vertical.getWidth(), y, x + width, y);
            } else {
                g.drawLine(x, y, x + width, y);
            }
            g.setColor(((StandardGradientPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!vertical.isVisible()) {
                if (horizontal.isVisible()) {
                    g.drawLine(x, y, x, y + height - horizontal.getHeight());
                } else {
                    g.drawLine(x, y, x, y + height - 1);
                }
            }
            g.setColor(((StandardGradientPainter)painter).getBottomBorderColor(scheme, scheme, 0.0, false));
            if (!horizontal.isVisible()) {
                if (vertical.isVisible()) {
                    g.drawLine(x + vertical.getWidth(), y + height - 1, x + width, y + height - 1);
                } else {
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
            g.setColor(((StandardGradientPainter)painter).getTopBorderColor(scheme, scheme, 0.0, false));
            if (horizontal.isVisible()) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - horizontal.getHeight());
            } else {
                g.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
        }
    }
}

