/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Comparateur;
import criteres.Critere;
import criteres.CritereActifIllustratif;
import criteres.CritereCompose;
import criteres.CritereIndividu;
import criteres.Info;
import criteres.Singleton;
import don.DonneeID;
import don.Individu;
import drawing.Series;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import outils.Fichier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trieur {
    private Critere m_critere;
    private SortedSet<Series> m_mesSeries;

    public Trieur(Critere critere) {
        this.m_critere = critere;
        this.m_mesSeries = new TreeSet<Series>(new Comparateur(this.m_critere));
    }

    public Critere getCritere() {
        return this.m_critere;
    }

    public void trier(Vector<DonneeID> liste) {
        Info i = new Singleton(Integer.MAX_VALUE);
        for (DonneeID don : liste) {
            i = this.m_critere.evaluer(don);
            if (i.isError()) continue;
            this.addMesSeries(this.m_mesSeries, i, don, this.m_critere);
        }
    }

    private void addMesSeries(Set<Series> mesSeries, Info i, DonneeID don, Critere crit) {
        if (don != null) {
            Iterator<Series> iter = mesSeries.iterator();
            boolean trouve = false;
            while (iter.hasNext() && !trouve) {
                Series courante = iter.next();
                if (!courante.getDefinition().equals(i)) continue;
                courante.addDonneeID(don);
                trouve = true;
            }
            if (!trouve) {
                Series nouvelle = new Series(i, crit.semantique(i));
                nouvelle.addDonneeID(don);
                mesSeries.add(nouvelle);
            }
        }
    }

    @Deprecated
    public SortedSet<Series> getSeries(Critere selection) {
        TreeSet<Series> mesSeries = new TreeSet<Series>(new Comparateur(this.m_critere));
        for (Series s : this.m_mesSeries) {
            int i = 0;
            while (i < s.getNbDonneeID()) {
                CritereCompose crit = new CritereCompose(this.m_critere, selection);
                DonneeID don = s.getDonneeID(i);
                Info n = crit.evaluer(don);
                if (!n.isError()) {
                    this.addMesSeries(mesSeries, n, don, crit);
                }
                ++i;
            }
        }
        return mesSeries;
    }

    public SortedSet<Series> getSeries() {
        return this.m_mesSeries;
    }

    public static void main(String[] args) {
        Fichier.chargerDonnees("C:\\Documents and Settings\\sle\\Bureau\\MichaelOry\\dynGraph\\jeudedonnees.ser");
        Critere c = new CritereIndividu();
        Individu indActif = new Individu("ind", true, null, null, null, null, null);
        Individu indIllus = new Individu("ind", false, null, null, null, null, null);
        System.out.println("individu tri\ufffd par test individu : " + c.evaluer(indActif) + " qualif : " + c.qualifier(indActif));
        c = new CritereActifIllustratif();
        System.out.println("actif tri\ufffd par test actif/illus :" + c.evaluer(indActif) + " qualif : " + c.qualifier(indActif));
        System.out.println("illus tri\ufffd par test actif/illus :" + c.evaluer(indIllus) + " qualif : " + c.qualifier(indIllus));
        System.out.println("===========================");
        c = new CritereCompose(new CritereCompose(new CritereIndividu(), new CritereActifIllustratif()), new CritereIndividu());
        System.out.println("ind actif tri\ufffd par test ind + actif/illus :" + c.evaluer(indActif) + " qualif : " + c.qualifier(indActif));
        System.out.println("ind illus tri\ufffd par test ind + actif/illus :" + c.evaluer(indIllus) + " qualif : " + c.qualifier(indIllus));
    }
}

