% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dici.R
\name{dici}
\alias{dici}
\title{Estimate of of mosquito dispersal}
\usage{
dici(
  input_sim = NULL,
  coords = NULL,
  eval_date = NULL,
  breaks = c(0.25, 0.5, 0.75),
  space = FALSE
)
}
\arguments{
\item{input_sim}{matrix. \code{dynamAedes.m} compressed output matrix (\code{compressed=TRUE}).}

\item{coords}{matrix. A matrix reporting the spatial coordinates of the temperature observations.}

\item{eval_date}{numeric. Define the day of evaluation; it refers to the column number of the input temperature matrix.}

\item{breaks}{numeric vector. Quantile breaks, default interquartile range: \code{c(0.25,0.5,0.75)}.}

\item{space}{See below for more details.}
}
\value{
if space=FALSE then it returns a dataframe with quantiles of the distribution of dispersal distances; if space=TRUE (experimental) then it returns the invaded cells on the last day of model simulations for each of the iterations.
}
\description{
Estimates of dispersal (in km^2) for the simulated mosquito population when \code{scale = "lc"}.
}
\author{
Matteo Marcantonio \email{marcantoniomatteo@gmail.com}, Daniele Da Re \email{daniele.dare@uclouvain.be}
}
