% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfaHB.R
\name{cfaHB}
\alias{cfaHB}
\alias{print.cfaHB}
\title{Dynamic fit index (DFI) cutoffs adapted from Hu & Bentler (1999) for multi-factor CFA models}
\usage{
cfaHB(model, n = NULL, plot = FALSE, manual = FALSE, reps = 500)

\method{print}{cfaHB}(x, ...)
}
\arguments{
\item{model}{This can either be a \code{\link{lavaan}} object from the \code{\link{cfa}} function,
OR a model statement written in \code{\link{lavaan}} \code{\link{model.syntax}} with standardized loadings.}

\item{n}{If you entered a \code{\link{lavaan}} object for model, leave this blank.
Otherwise, enter your sample size (numeric).}

\item{plot}{Displays distributions of fit indices for each level of misspecification.}

\item{manual}{If you entered a \code{\link{lavaan}} object, keep this set to FALSE.
If you manually entered standardized loadings and sample size, set this to TRUE.}

\item{reps}{(**Do not modify this**): The number of replications used in your simulation. This is set to 500 by default in both the
R package and the corresponding Shiny App.}

\item{x}{cfaHB object}

\item{...}{other print parameters}
}
\value{
Dynamic fit index (DFI) cutoffs for SRMR, RMSEA, and CFI.
}
\description{
This function generates DFI cutoffs adapted from Hu & Bentler (1999) for multi-factor CFA models using ML estimation.
The default argument is a singular argument: a \code{\link{lavaan}} object from the \code{\link{cfa}} function.
The function can also accommodate manual entry of the model statement and sample size.

The app-based version of this function can be found at \href{https://dynamicfit.app/}{dynamicfit.app}.
}
\examples{
#Lavaan object example (manual=FALSE)
dat <- lavaan::HolzingerSwineford1939
lavmod <- "F1 =~ x1 + x2 + x3
           F2 =~ x4 + x5 + x6
           F3 =~ x7 + x8 + x9"
fit <- lavaan::cfa(lavmod,dat)
\donttest{cfaHB(fit)}

#Manual entry example for a sample size of 400 (manual=TRUE)
manmod <- "F1 =~ .602*Y1 + .805*Y2 + .516*Y3 + .415*Y4
           F2 =~ .413*Y5 + -.631*Y6
           F1 ~~ .443*F2
           Y4 ~~ .301*Y5"
\donttest{exactFit(model=manmod,n=400,manual=TRUE)}

}
\author{
Melissa G Wolf & Daniel McNeish

Maintainer: Melissa G Wolf <missgord@gmail.com>
}
