% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_table.R
\name{as.data.table.dynamitefit}
\alias{as.data.table.dynamitefit}
\alias{as.data.table}
\title{Extract Samples From a \code{dynamitefit} Object as a Data Table}
\usage{
\method{as.data.table}{dynamitefit}(
  x,
  keep.rownames = FALSE,
  row.names = NULL,
  optional = FALSE,
  responses = NULL,
  types = NULL,
  summary = TRUE,
  probs = c(0.05, 0.95),
  include_fixed = TRUE,
  ...
)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{keep.rownames}{[\code{logical(1)}]\cr Not used.}

\item{row.names}{Ignored.}

\item{optional}{Ignored.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.}

\item{types}{[\code{character()}]\cr Type(s) of the parameters for which the
samples should be extracted. See details of possible values. Default is
all values listed in details except spline coefficients \code{omega} and
\code{omega_alpha}.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE} (default), returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE}, returns the posterior
samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{include_fixed}{[\code{logical(1)}]\cr If \code{TRUE} (default), time-varying
parameters for \code{1:fixed} time points are included in the output as \code{NA}
values. If \code{FALSE}, fixed time points are omitted completely
from the output.}

\item{...}{Ignored.}
}
\value{
A \code{data.table} containing either samples or summary statistics of
the model parameters.
}
\description{
Provides a \code{data.table} representation of the posterior samples of the model
parameters. See \code{\link[=as.data.frame.dynamitefit]{as.data.frame.dynamitefit()}} for details.
}
\examples{
as.data.table(
  gaussian_example_fit,
  responses = "y",
  types = "beta",
  summary = FALSE
)

}
