% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_psis}
\alias{plot_psis}
\title{Plot Latent Factors of a Dynamite Model}
\usage{
plot_psis(
  x,
  responses = NULL,
  level = 0.05,
  alpha = 0.5,
  scales = c("fixed", "free")
)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object}

\item{responses}{[\code{character()}]\cr Response(s) for which the coefficients
should be drawn. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this whole vector.}

\item{level}{[\code{numeric(1)}]\cr Level for posterior intervals.
Default is 0.05, leading to 90\% intervals.}

\item{alpha}{[\code{numeric(1)}]\cr Opacity level for \code{geom_ribbon}.
Default is 0.5.}

\item{scales}{[\code{character(1)}] Should y-axis of the panels be \code{"fixed"}
(the default) or \code{"free"}? See \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot Latent Factors of a Dynamite Model
}
