% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_numeric.R
\name{numeric_parameter}
\alias{numeric_parameter}
\title{Define a numeric parameter}
\usage{
numeric_parameter(
  id,
  default,
  distribution,
  description = NULL,
  tuneable = TRUE
)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{distribution}{A distribution from which the parameter can be sampled.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a numeric parameter
}
\examples{
numeric_parameter(
  id = "alpha",
  default = 0.5,
  distribution = uniform_distribution(0.0, 1.0),
  description = "Weighting parameter for distance function."
)

numeric_parameter(
  id = "beta",
  default = 0.001,
  distribution = expuniform_distribution(1e-4, 1e-1),
  description = "Percentage decrease in age per iteration"
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
