% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_cell_graph.R
\name{add_cell_graph}
\alias{add_cell_graph}
\title{Constructs a trajectory using a graph between cells, by mapping cells onto a set of backbone cells.}
\usage{
add_cell_graph(
  dataset,
  cell_graph,
  to_keep,
  milestone_prefix = "milestone_",
  ...
)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{cell_graph}{The edges between cells, a dataframe containing the \emph{from} and \emph{to} cells, the *length, and whether this edge is \emph{directed}}

\item{to_keep}{Whether a cells is part of the backbone. May be a character vector with the identifiers of the backbone cells, or a named boolean vector whether a cell is from the backbone}

\item{milestone_prefix}{A prefix to add to the id of the cell ids when they are used as milestones, in order to avoid any naming conflicts,}

\item{...}{extra information to be stored in the wrapper.}
}
\value{
A trajectory object
}
\description{
The cells that are part of the backbone will form the trajectory. All other cells are moved towards the nearest cell that is part of the backbone.
}
\examples{
library(dplyr)
dataset <- wrap_data(cell_ids = letters)

backbone_cell_graph <- tibble::tibble(
  from = letters[1:10],
  to = letters[2:11],
  length = 1,
  directed = TRUE
)
leaves_cell_graph <- tibble::tibble(
  from = letters[12:26],
  to = sample(letters[1:11], 15, replace = TRUE),
  length = 1,
  directed = TRUE
)
cell_graph <- bind_rows(backbone_cell_graph, leaves_cell_graph)
cell_graph
to_keep <- letters[1:11]
to_keep

trajectory <- add_cell_graph(dataset, cell_graph, to_keep)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
