% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_enrich.R
\name{node_IC_zhou}
\alias{node_IC_zhou}
\title{Calculate Node Information Content (Zhou et al 2008 method)}
\usage{
node_IC_zhou(graph, mode = "in", root, k = 0.5)
}
\arguments{
\item{graph}{\code{\link[tidygraph:tidygraph]{tidygraph}} directed graph.}

\item{mode}{Character constant specifying the directionality of the edges.
One of "in" or "out".}

\item{root}{name of root node identifier in column 1 to calculate node depth
from.}

\item{k}{numeric value to adjust the weight of the two items of information
content equation (relative number of hyponyms/descendants and relative node
depth). Default = 0.5}
}
\value{
tidygraph with additional node attribute "information_content"
}
\description{
Computes the information content for each node in a directed graph according
to the equation developed by Zhou \emph{et al.} (2008).
}
\note{
For use in semantic enrichment, this should be applied before joining
  an ontology with nodes representing data variables (i.e. before applying
  \code{\link{join_vars_to_ontol}}.
}
\examples{
data(example_ontology)
node_IC_zhou(example_ontology, mode = "in", root = "root")
}
\references{
Zhou, Z., Wang, Y. & Gu, J. A New Model of Information Content
  for Semantic Similarity in WordNet. in 2008 Second International Conference
  on Future Generation Communication and Networking Symposia vol. 3 85–89
  (2008).
}
