% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_hawkessim.R
\docType{methods}
\name{pc_hawkessim-class}
\alias{pc_hawkessim-class}
\alias{pc_hawkessim}
\alias{pc_hawkessim-methods}
\alias{pc_hawkessim,simHawkes-method}
\title{A method to simulate nonstationary Hawkes models.}
\usage{
pc_hawkessim(object)

\S4method{pc_hawkessim}{simHawkes}(object)
}
\arguments{
\item{object}{a simHawkes object}
}
\value{
Returns an object of \code{simHawkes} class containing a simulated piecewise constant Hawkes series.
}
\description{
A S4 method that takes as an input a \code{simHawkes} object and outputs a simulated nonstationary Hawkes model. The formulation of the of the 
piecewise constant ACD model is given in the \code{simHawkes} class.
}
\examples{
pw.hawk.obj <- new("simHawkes")
pw.hawk.obj@cp.loc <- c(0.5)
pw.hawk.obj@lambda_0 <- c(1,2)
pw.hawk.obj@alpha <- c(0.2,0.2)
pw.hawk.obj@beta <- c(0.7,0.7)
pw.hawk.obj@horizon <- 1000
pw.hawk.obj <- pc_hawkessim(pw.hawk.obj)
ts.plot(pw.hawk.obj@H)
ts.plot(pw.hawk.obj@cH)
}
\references{
Korkas Karolos. "Ensemble Binary Segmentation for irregularly spaced data with change-points" <arXiv:2003.03649>.
}
