% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_S4_Generics.R, R/factor_ops.R
\name{replaceEntries}
\alias{replaceEntries}
\alias{replaceEntries,vector,list-method}
\title{Replace entries according to a mapping list}
\usage{
replaceEntries(x, map, ...)

\S4method{replaceEntries}{vector,list}(x, map, ...)
}
\arguments{
\item{x}{An R vector}

\item{map}{A named list representing one-to-one or one-to-many mappings.
Normally, each name represents a new value, and each element contain the old
value(s) to be replaced.}

\item{...}{Arguments passed to other methods.}
}
\value{
A updated \code{x}
}
\description{
Replace entries according to a mapping list
}
\examples{
set.seed(1234)
fact <- factor(c("A", "A", "B", "A", "B", "C", "D", "E", "D"))
map <- list("a" = c("B", "e")) ## Turn all "B" and "E" into "a"
replaceEntries(fact, map)

}
