% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EnsError.R
\name{EnsError}
\alias{EnsError}
\alias{EnsMae}
\alias{EnsMe}
\alias{EnsMse}
\alias{EnsRmse}
\title{Ensemble Mean Error}
\usage{
EnsError(ens, obs, type)

EnsMe(ens, obs)

EnsMae(ens, obs)

EnsMse(ens, obs)

EnsRmse(ens, obs)
}
\arguments{
\item{ens}{n x k matrix of n forecasts from k ensemble members}

\item{obs}{n verifying observations}

\item{type}{specifying what error metric to compute, one of [me, mae, mse,
  rmse]}
}
\description{
Computes various ensemble mean error scores. \code{EnsMe}
computes the mean error, \code{EnsMae} the mean absolute error, \code{EnsMse}
the mean squared error, and \code{EnsRmse} the square root of the mean
squared error (for consistency with the veri package).
}
\examples{
#forecast and observations
tm <- toymodel()

# compute the mean bias
EnsError(tm$fcst, tm$obs, type='me')
# equivalently
EnsMe(tm$fcst, tm$obs)
}
\seealso{
\code{\link{veriApply}}, \code{\link{EnsErrorss}}
}

