% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marginal_hist.R
\name{plot_all_hists}
\alias{plot_all_hists}
\title{plot marginal histograms of alluvial plot}
\usage{
plot_all_hists(p, data_input, top = TRUE, keep_labels = FALSE, ...)
}
\arguments{
\item{p}{alluvial plot}

\item{data_input}{dataframe, input data that was used to create dataframe}

\item{top}{logical, position of histograms, if FALSE adds them at the bottom,
Default: TRUE}

\item{keep_labels}{logical, keep title and caption, Default: FALSE}

\item{...}{additional arguments for specific alluvial plot types: pred_train
can be used to pass training predictions for model response alluvials}
}
\value{
gtable
}
\description{
will create gtable with densitiy histograms and frequency plots
  of all variables of a given alluvial plot.
}
\examples{
p = alluvial_wide(mtcars2, max_variables = 4)
plot_all_hists(p, mtcars2)
}
\seealso{
\code{\link[gridExtra]{arrangeGrob}}

\code{\link[easyalluvial]{add_marginal_histograms}}
}
