% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EAT.R
\name{descrEAT}
\alias{descrEAT}
\title{Leaf Nodes Descriptive}
\usage{
descrEAT(object)
}
\arguments{
\item{object}{An \code{EAT} object.}
}
\value{
List with centralization and dispersion measures and the root mean squared error (RMSE) for each node. In case of a single output, the result of the function is a \code{data.frame}.
}
\description{
This function returns a set of common measures for the leaf nodes of an Efficiency Analysis Trees model.
}
\examples{
simulated <- Y1.sim(N = 50, nX = 3)
model <- EAT(data = simulated, x = c(1, 2, 3), y = 4, numStop = 10, fold = 5)
descrEAT(model)

}
