% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingRFEAT.R
\name{rankingRFEAT}
\alias{rankingRFEAT}
\title{Ranking of variables by Random Forest + Efficiency Analysis Trees model.}
\usage{
rankingRFEAT(object, barplot = TRUE, digits = 2)
}
\arguments{
\item{object}{A \code{RFEAT} object.}

\item{barplot}{\code{logical}. If \code{TRUE}, a barplot with importance scores is displayed.}

\item{digits}{Decimal units.}
}
\value{
\code{data.frame} with the importance scores and a barplot representing the variable importance if \code{barplot = TRUE}.
}
\description{
This function calculates variable importance through a Random Forest + Efficiency Analysis Trees model.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
RFEAT_model <- RFEAT(data = simulated, x = c(1,2), y = c(3, 4))

rankingRFEAT(object = RFEAT_model,
             barplot = TRUE,
             digits = 2)
}

}
