% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareConstraints.R
\name{prepareConstraints}
\alias{prepareConstraints}
\title{Prepare a list of constraints for \code{Gurobi}}
\usage{
prepareConstraints(allConstraints, nForms, nItems)
}
\arguments{
\item{allConstraints}{List of constraints.}

\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}
}
\value{
A \code{gurobi} model list.
}
\description{
Transform a list of constraints set up via \code{eatATA} as input to the \code{gurobi} function.
}
\examples{
## setup some example constraints
usage <- itemUsageConstraint(nForms = 2, nItems = 10, operator = "=", targetValue = 1)
perForm <- itemsPerFormConstraint(nForms = 2, nItems = 10, operator = "=", targetValue = 5)
target <- itemTargetConstraint(nForms = 2, nItems = 10, itemValues = 1:10, targetValue = 5)

## Prepare Constraints
prepareConstraints(list(usage, perForm, target), nForms = 2, nItems = 10)

}
