% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check4SPSS.R
\name{check4SPSS}
\alias{check4SPSS}
\title{Check \code{SPSS} Compliance of Meta Data}
\usage{
check4SPSS(GADSdat)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}
}
\value{
Returns a list with the entries \code{"varNames_special"}, \code{"varNames_length"},
\code{"varLabels"}, \code{"valLabels"} and \code{"missings"}.
}
\description{
Function to check if variable names and labels, value labels and missing codes comply with \code{SPSS} requirements for meta data.
}
\details{
The function measures the length of variable names (\code{"varNames_length"}, maximum of 64 characters)
variable labels (\code{"varLabels"}, maximum of 256 characters),
value labels (\code{"valLabels"}, maximum of 120 characters). Furthermore,
missing codes are counted (\code{"missings"}, maximum of three missing codes for character variables)
and special characters are flagged in variable names (\code{"varNames_special"}).
Check results are reported back on variable level, with the exception of \code{"valLabels"}, which is a list
with entries per violating variable.
}
\examples{
# Change example data set (create a violating label)
pisa2 <- changeVarLabels(pisa, varName = "computer_age",
                        varLabel = paste(rep("3", 125), collapse = ""))

check4SPSS(pisa2)

}
