% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_datazoom}
\alias{e_datazoom}
\title{Data zoom}
\usage{
e_datazoom(e, x.index = NULL, y.index = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{x.index}{Indexes of x and y axis.}

\item{y.index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add data zoom.
}
\examples{
USArrests \%>\% 
  e_charts(UrbanPop) \%>\% 
  e_line(Assault) \%>\% 
  e_area(Murder, y.index = 1, x.index = 1) \%>\% 
  e_y_axis(gridIndex = 1) \%>\%
  e_x_axis(gridIndex = 1) \%>\% 
  e_grid(height = "35\%") \%>\% 
  e_grid(height = "35\%", top = "50\%") \%>\% 
  e_toolbox_feature("dataZoom", title = list(zoom = "zoom", back = "back")) \%>\% 
  e_datazoom(x.index = c(0, 1))

}
\seealso{
\href{Additional arguments}{https://ecomfe.github.io/echarts-doc/public/en/option.html#dataZoom}
}
