% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_treemap}
\alias{e_treemap}
\alias{e_treemap_}
\title{Treemap}
\usage{
e_treemap(e, parent, child, value, rm.x = TRUE, rm.y = TRUE, ...)

e_treemap_(e, parent, child, value, rm.x = TRUE, rm.y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{parent, child}{Edges.}

\item{value}{Value of edges.}

\item{rm.x, rm.y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Build a treemap.
}
\examples{
df <- data.frame(
  parent = c("earth", "earth", "earth", "mars", "mars"), 
  child = c("forest", "ocean", "iceberg", "elon", "curiosity"),
  value = ceiling(rnorm(5, 10, 2))
)

df \%>\% 
  e_charts() \%>\% 
  e_treemap(parent, child, value)
  
}
\seealso{
\href{Additional arguments}{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-treemap}
}
