% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_inspect}
\alias{e_inspect}
\alias{echarts_from_json}
\title{To & From JSON}
\usage{
e_inspect(e, json = FALSE, ...)

echarts_from_json(txt)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{json}{Whether to return the JSON, otherwise returns a \code{list}.}

\item{...}{Additional options to pass to \link[=jsonlite]{toJSON}.}

\item{txt}{JSON character string, url, or file.}
}
\value{
\code{e_inspect} Returns a \code{list} if \code{json} is \code{FALSE} and a
JSON string otherwise. \code{echarts_from_json} returns an object of class \code{echarts4r}.
}
\description{
Get JSON options from an echarts4r object and build one from JSON.
}
\details{
\code{txt} should contain the full list of options required to build a chart.
This is subsequently passed to the \code{setOption} ECharts (JavaScript) function.
}
\note{
Must be passed as last option.
}
\examples{
p <- cars \%>\%
  e_charts(dist) \%>\%
  e_scatter(speed, symbol_size = 10)

p # plot

# extract the JSON
json <- p \%>\%
  e_inspect(
    json = TRUE,
    pretty = TRUE
  )

# print json
json

# rebuild plot
echarts_from_json(json) \%>\%
  e_theme("dark") # modify
}
