% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_bar}
\alias{e_bar}
\alias{e_bar_}
\title{Bar and Line chart}
\usage{
e_bar(
  e,
  serie,
  bind,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)

e_bar_(
  e,
  serie,
  bind = NULL,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{bind}{Binding between datasets, namely for use of \code{\link{e_brush}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{coord_system}{Coordinate system to plot against.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add bar serie.
}
\note{
The bar serie expects the data on the x axis to be
\code{categorical} in R this means a \code{factor} or 
\code{character}. If the data on the x axis is numeric
everything should work well in most cases but strange
behaviour may be observed.
}
\examples{
library(dplyr)

mtcars |>
  tibble::rownames_to_column("model") |> 
  mutate(total = mpg + qsec) |>
  arrange(desc(total)) |>
  e_charts(model) |>
  e_bar(mpg, stack = "grp") |>
  e_bar(qsec, stack = "grp")
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-bar}{Additional arguments}
}
