% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_archetype.R
\name{wf_archetype}
\alias{wf_archetype}
\title{Creates an archetype function}
\usage{
wf_archetype(request, dynamic_fields)
}
\arguments{
\item{request}{a MARS or CDS request as an R list object.}

\item{dynamic_fields}{character vector of fields that could be changed.}
}
\value{
a function that takes `dynamic_fields` as arguments and returns a
request as an R list object.
}
\description{
Creates a universal MARS / CDS formatting function, in ways
similar to \code{wf_modify_request()} but the added advantage
that you could code for the use of dynamic changes in the
parameters provided to the resulting custom function.
}
\details{
Contrary to a simple replacement as in \code{wf_modify_request()} the
generated functions are considered custom user written. Given the potential
for complex formulations and formatting commands NO SUPPORT for the
resulting functions can be provided. Only the generation of a valid function
will be guaranteed and tested for.
}
\examples{
\dontrun{
# format an archetype function
ERAI <- wf_archetype(
  request = list(stream = "oper",
                 levtype = "sfc",
                 param = "165.128/166.128/167.128",
                 dataset = "interim",
                 step = "0",
                 grid = "0.75/0.75",
                 time = "00/06/12/18",
                 date = "2014-07-01/to/2014-07-31",
                 type = "an",
                 class = "ei",
                 area = "73.5/-27/33/45",
                 format = "netcdf",
                 target = "tmp.nc"),
  dynamic_fields = c("date", "time")
)

# print output of the function with below parameters
str(ERA_interim("20100101", 3, 200))

}
}
