% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\alias{prepdata}
\title{Prepare Data for Evaluation}
\usage{
prep_data(
  data,
  type = "counts",
  Sest.method = "average",
  cases = 5,
  N = 100,
  M = 3,
  n,
  m,
  k = 50,
  transformation = "none",
  method = "bray",
  dummy = FALSE,
  useParallel = TRUE,
  model = "single.factor"
)
}
\arguments{
\item{data}{Data frame where columns represent species names and rows correspond
to samples.
\itemize{
\item For \code{"single.factor"} analysis: The first column should indicate the replicate
to which the sample belongs.
\item For \code{"nested.symmetric"} analysis: The first column should indicate the
treatment, and the second column should indicate the replicate.
}}

\item{type}{Character. Nature of the data to be processed. It may be presence
/ absence ("P/A"), counts of individuals ("counts"), or coverage ("cover").}

\item{Sest.method}{Character Method for estimating species richness using
\code{\link[vegan:specpool]{vegan::specpool()}}. Available methods are the incidence-based Chao ("chao"),
first order jackknife ("jack1"), second order jackknife ("jack2") and Bootstrap
("boot"). By default, the average ("average") of the four estimates is used.}

\item{cases}{Integer. Number of simulated datasets.}

\item{N}{Integer. Total number of samples simulated per site.}

\item{M}{Integer. Total number of replicates simulated per dataset.}

\item{n}{Integer. Maximum number of samples to consider (must be \verb{<= N}).}

\item{m}{Integer. Number of replicates to consider. (must be \verb{<=M})}

\item{k}{Integer. Number of resampling iterations. Defaults to 50.}

\item{transformation}{Character. Transformation applied to reduce the weight
of dominant species: "square root", "fourth root", "Log (X+1)", "P/A", "none".}

\item{method}{Character. Dissimilarity metric used \code{\link[vegan:vegdist]{vegan::vegdist()}}. Common
options include: "Gower", "Bray–Curtis", "Jaccard", etc.}

\item{dummy}{Logical. If \code{TRUE}, adds a small constant to empty observations.}

\item{useParallel}{Logical.  If \code{TRUE}, enables parallel computation. Defaults
to \code{TRUE}.}

\item{model}{Character. Select the model to use. Options, so far, are
\code{"single.factor"} and \code{"nested.symmetric"}.}
}
\value{
\code{prep_data()} returns an object of class "ecocbo_data".

An object of class "ecocbo_data" is a list containing:
\itemize{
\item \code{$Results}, a data frame that lists the estimates of pseudoF for
\code{simH0} and \code{simHa}, useful for statistical power analysis. It also
includes mean squares for variance component estimation.
\item \code{$model}, a label for keeping track of the model that is being used
in the analysis.
\item \code{$a}, an integer for the number of treatments recorded from the original
data.
}
}
\description{
Formats and arranges the initial data so that it can be
readily used by the other functions in the package. The function first gets
the species names and the number of samples for each species from the input
data frame. Then, it permutes the sampling efforts and calculates the pseudo-F
statistic and the mean squares for each permutation. Finally, it returns a
data frame with the permutations, pseudo-F statistic, and mean squares.
}
\details{
The input dataset should have:
\itemize{
\item One or two leading columns for treatment/replicate labels.
\item Subsequent columns representing species presence/absence, counts, or coverage.
\item \code{"single.factor"} requires a single column for replicates.
\item \code{"nested.symmetric"} requires two columns: treatment and replicate in that
order.
}
}
\examples{
\donttest{
simResults <- prep_data(data = epiDat, type = "counts", Sest.method = "average",
                        cases = 5, N = 100, M = 10,
                        n = 5, m = 5, k = 30,
                        transformation = "none", method = "bray",
                        dummy = FALSE, useParallel = FALSE,
                        model = "single.factor")
}
simResults

}
\references{
\itemize{
\item Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
\item Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=scompvar]{scompvar()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
