% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_entity_pattern.R
\name{add_entity_pattern}
\alias{add_entity_pattern}
\title{Add a custom entity pattern}
\usage{
add_entity_pattern(
  entity_id,
  entity_name,
  entity_type,
  aliases = NULL,
  entity_regex = NULL
)
}
\arguments{
\item{entity_id}{A unique identifier for the entity.}

\item{entity_name}{The standard (canonical) name of the entity.}

\item{entity_type}{A character string describing the type of entity
("economy", "organization", "aggregate", or "other").}

\item{aliases}{An optional character vector of alternative names identifying
the entity. If provided, these are automatically combined (using the pipe
operator, "|") with \code{entity_name} and \code{entity_id} to construct
a regular expression pattern.}

\item{entity_regex}{An optional custom regular expression pattern. If
supplied, it overrides the regex automatically constructed from
\code{aliases}.}
}
\value{
\code{NULL}. As a side effect of the function, the custom pattern is
stored in an internal tibble for the current session.
}
\description{
This function allows users to extend the default entity patterns with a
custom entry.
}
\details{
Custom entity patterns can be added at the top of a script (or
interactively) and will be appended to the built-in patterns when using
\code{list_entity_patterns()}. This makes it possible for users to register
alternative names (aliases) for entities that might appear in their economic
datasets.

The custom entity patterns are kept separately and are appended to
the default patterns when retrieving the entity_patterns via
\code{list_entity_patterns()}. The custom patterns will only persist
for the length of the R session.
}
\examples{
add_entity_pattern(
  "ASN",
  "Association of Southeast Asian Nations",
  "economy",
  aliases = c("ASEAN")
)
patterns <- list_entity_patterns()
print(patterns[patterns$entity_id == "ASN", ])


}
