% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.gauss.R
\name{setupGaussMutator}
\alias{setupGaussMutator}
\title{Generator of the Gaussian mutation operator.}
\usage{
setupGaussMutator(p = 1L, sdev = 0.05)
}
\arguments{
\item{p}{[\code{numeric(1)}]\cr
Probability of mutation for the gauss mutation operator.}

\item{sdev}{[\code{numeric(1)}\cr
Standard deviance of the Gauss mutation, i. e., the mutation strength.}
}
\value{
[\code{ecr_mutator}]
}
\description{
Default Gaussian mutation operator known from Evolutionary Algorithms.
This mutator is applicable only for \code{representation="float"}. Given
an individual \eqn{\mathbf{x} \in R^l} this mutator adds a Gaussian
distributed random value to each component of \eqn{\mathbf{x}}, i.~e.,
\eqn{\tilde{\mathbf{x}}_i = \mathbf{x}_i + \sigma \mathcal{N}(0, 1)}.
}
\seealso{
Other mutators: \code{\link{setupBitFlipMutator}},
  \code{\link{setupInsertionMutator}},
  \code{\link{setupPolynomialMutator}},
  \code{\link{setupScrambleMutator}},
  \code{\link{setupSwapMutator}},
  \code{\link{setupUniformMutator}}
}

