% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_trace_frequency.R
\name{filter_trace_frequency}
\alias{filter_trace_frequency}
\alias{filter_trace_frequency.eventlog}
\alias{filter_trace_frequency.grouped_eventlog}
\alias{ifilter_trace_frequency}
\title{Filter: Trace frequency}
\usage{
filter_trace_frequency(eventlog, interval, percentage, reverse, ...)

\method{filter_trace_frequency}{eventlog}(eventlog, interval = NULL,
  percentage = NULL, reverse = FALSE, ...)

\method{filter_trace_frequency}{grouped_eventlog}(eventlog, interval = NULL,
  percentage = NULL, reverse = FALSE, ...)

ifilter_trace_frequency(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{interval}{WHen given an interval, the filter will select cases of which the trace has a frequency inside the interval.}

\item{percentage}{When given a percentage p, the filter will select the most common traces, until at least p\% of the cases is covered.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based the frequency of traces, using an interval or a percentile cut off.
}
\details{
This filter can be used to filter cases based on the frequency of the corresponding trace.
A trace is a sequence of activity labels, and will be discussed in
more detail in Section 6. There are again two ways to select cases based on trace frequency,
by interval or by percentile cut off. The percentile cut off will start with the most frequent
traces.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
