% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size_of_selfloops.R
\name{size_of_selfloops}
\alias{size_of_selfloops}
\alias{size_of_selfloops.eventlog}
\alias{size_of_selfloops.grouped_eventlog}
\alias{size_of_selfloops.activitylog}
\alias{size_of_selfloops.grouped_activitylog}
\title{Metric: Size of selfloops}
\usage{
size_of_selfloops(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  eventlog = deprecated()
)

\method{size_of_selfloops}{eventlog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  eventlog = deprecated()
)

\method{size_of_selfloops}{grouped_eventlog}(
  log,
  type = c("repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-acitivty"),
  append = deprecated(),
  append_column = NULL,
  eventlog = deprecated()
)

\method{size_of_selfloops}{activitylog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  eventlog = deprecated()
)

\method{size_of_selfloops}{grouped_activitylog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity"),
  append = deprecated(),
  append_column = NULL,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{type}{\code{\link{character}} (default \code{"all"}): The type of repetitions: \code{"all"} (default),
\code{"repeat"}, or \code{"redo"}. For more information, see 'Details' below.}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}

\item{append}{\code{\link{logical}} (default \code{FALSE}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: The arguments \code{append} and \code{append_column}
have been deprecated in favour of \code{\link{augment}}.\cr
Indicating whether to append results to original log. Ignored when level is \code{"log"} or \code{"trace"}.}

\item{append_column}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The arguments \code{append} and \code{append_column} have been deprecated in favour of \code{\link{augment}}.\cr
Which of the output columns to append to log, if \code{append = TRUE}. Default column depends on chosen level.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
Provides summary statistics on the sizes of selfloops
}
\section{Methods (by class)}{
\itemize{
\item \code{size_of_selfloops(eventlog)}: Size of selfloops for eventlog

\item \code{size_of_selfloops(grouped_eventlog)}: Size of selfloops for grouped eventlog

\item \code{size_of_selfloops(activitylog)}: Size of selfloops for activitylog

\item \code{size_of_selfloops(grouped_activitylog)}: Size of selfloops for grouped activitylog

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{number_of_selfloops}}
}
\concept{metrics_repetition}
