% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMasterIndex.R
\name{getMasterIndex}
\alias{getMasterIndex}
\title{Retrieves quarterly master index.}
\usage{
getMasterIndex(year.array)
}
\arguments{
\item{year.array}{year in integer or integer array containing years for which master 
index are to be downloaded.}
}
\value{
Function retrieves quarterly master index files 
from \url{https://www.sec.gov/Archives/edgar/full-index/} site and returns download status dataframe.
}
\description{
\code{getMasterIndex} retrieves the quarterly master index from US SEC site.
}
\details{
getMasterIndex function takes filing year as an input parameter from user,  
download quarterly master index from https://www.sec.gov/Archives/edgar/full-index/.
It strips the headers, converts into dataframe, and merges such quarterly
dataframes into yearly dataframes and stored it in Rda format.
Function creates new directory 'Master Index' into working directory 
to save these Rda Master Index. Please note, for all other functions in this 
package needs to locate the same working directory to access these Rda master index files.
}
\examples{
\dontrun{

report <- getMasterIndex(1995) 
## Downloads quarterly master index files for the year 1995 and stores into yearly  
## 1995master.Rda file. It returns download report in dataframe format.

report <- getMasterIndex(c(1994, 2006, 2014)) 
## Download quarterly master index files for the years 1994, 1995, 2006 and stores into 
## different {year}master.Rda files. It returns download report in dataframe format.
}
}
