% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eDT.R
\name{eDT}
\alias{eDT}
\title{Create a modifieable datatable.}
\usage{
eDT(
  data,
  options = list(dom = "Bfrtlip", keys = TRUE, ordering = FALSE, autoFill = list(update =
    FALSE, focus = "focus"), buttons = list("add", "undo", "redo", "save")),
  class = "display",
  callback = NULL,
  rownames = FALSE,
  colnames = NULL,
  container,
  caption = NULL,
  filter = c("none", "bottom", "top"),
  escape = TRUE,
  style = "auto",
  width = NULL,
  height = NULL,
  elementId = NULL,
  fillContainer = getOption("DT.fillContainer", NULL),
  autoHideNavigation = getOption("DT.autoHideNavigation", NULL),
  selection = "none",
  extensions = c("KeyTable", "AutoFill", "Buttons"),
  plugins = NULL,
  editable = list(target = "cell"),
  id,
  keys = NULL,
  in_place = FALSE,
  format = function(x) {
     x
 },
  foreignTbls = list(),
  statusColor = c(insert = "#e6e6e6", update = "#32a6d3", delete = "#e52323"),
  inputUI = editbl::inputUI,
  defaults = tibble(),
  env = parent.frame()
)
}
\arguments{
\item{data}{\code{tbl}. The function will automatically cast to tbl if needed.}

\item{options}{a list of initialization options (see
\url{https://datatables.net/reference/option/}); the character options
wrapped in \code{\link[htmlwidgets]{JS}()} will be treated as literal
JavaScript code instead of normal character strings; you can also set
options globally via \code{\link{options}(DT.options = list(...))}, and
global options will be merged into this \code{options} argument if set}

\item{class}{the CSS class(es) of the table; see
\url{https://datatables.net/manual/styling/classes}}

\item{callback}{the body of a JavaScript callback function with the argument
\code{table} to be applied to the DataTables instance (i.e. \code{table})}

\item{rownames}{\code{TRUE} (show row names) or \code{FALSE} (hide row names)
or a character vector of row names; by default, the row names are displayed
in the first column of the table if exist (not \code{NULL})}

\item{colnames}{if missing, the column names of the data; otherwise it can be
an unnamed character vector of names you want to show in the table header
instead of the default data column names; alternatively, you can provide a
\emph{named} numeric or character vector of the form \code{'newName1' = i1,
'newName2' = i2} or \code{c('newName1' = 'oldName1', 'newName2' =
'oldName2', ...)}, where \code{newName} is the new name you want to show in
the table, and \code{i} or \code{oldName} is the index of the current
column name}

\item{container}{a sketch of the HTML table to be filled with data cells; by
default, it is generated from \code{htmltools::tags$table()} with a table
header consisting of the column names of the data}

\item{caption}{the table caption; a character vector or a tag object
generated from \code{htmltools::tags$caption()}}

\item{filter}{whether/where to use column filters; \code{none}: no filters;
\code{bottom/top}: put column filters at the bottom/top of the table; range
sliders are used to filter numeric/date/time columns, select lists are used
for factor columns, and text input boxes are used for character columns; if
you want more control over the styles of filters, you can provide a list to
this argument of the form \code{list(position = 'top', clear = TRUE, plain
= FALSE)}, where \code{clear} indicates whether you want the clear buttons
in the input boxes, and \code{plain} means if you want to use Bootstrap
form styles or plain text input styles for the text input boxes}

\item{escape}{whether to escape HTML entities in the table: \code{TRUE} means
to escape the whole table, and \code{FALSE} means not to escape it;
alternatively, you can specify numeric column indices or column names to
indicate which columns to escape, e.g. \code{1:5} (the first 5 columns),
\code{c(1, 3, 4)}, or \code{c(-1, -3)} (all columns except the first and
third), or \code{c('Species', 'Sepal.Length')}; since the row names take
the first column to display, you should add the numeric column indices by
one when using \code{rownames}}

\item{style}{either \code{'auto'}, \code{'default'}, \code{'bootstrap'}, or
\code{'bootstrap4'}. If \code{'auto'}, and a **bslib** theme is
currently active, then bootstrap styling is used in a way that "just works"
for the active theme. Otherwise,
\href{https://datatables.net/manual/styling/classes}{DataTables
\code{'default'} styling} is used. If set explicitly to \code{'bootstrap'}
or \code{'bootstrap4'}, one must take care to ensure Bootstrap's HTML
dependencies (as well as Bootswatch themes, if desired) are included on the
page. Note, when set explicitly, it's the user's responsibility to ensure
that only one unique `style` value is used on the same page, if multiple
DT tables exist, as different styling resources may conflict with each other.}

\item{width, height}{Width/Height in pixels (optional, defaults to automatic
sizing)}

\item{elementId}{An id for the widget (a random string by default).}

\item{fillContainer}{\code{TRUE} to configure the table to automatically fill
it's containing element. If the table can't fit fully into it's container
then vertical and/or horizontal scrolling of the table cells will occur.}

\item{autoHideNavigation}{\code{TRUE} to automatically hide navigational UI
(only display the table body) when the number of total records is less
than the page size. Note, it only works on the client-side processing mode
and the `pageLength` option should be provided explicitly.}

\item{selection}{the row/column selection mode (single or multiple selection
or disable selection) when a table widget is rendered in a Shiny app;
alternatively, you can use a list of the form \code{list(mode = 'multiple',
selected = c(1, 3, 8), target = 'row', selectable = c(-2, -3))} to
pre-select rows and control the selectable range; the element
\code{target} in the list can be \code{'column'} to enable column
selection, or \code{'row+column'} to make it possible to select both rows
and columns (click on the footer to select columns), or \code{'cell'} to
select cells. See details section for more info.}

\item{extensions}{a character vector of the names of the DataTables
extensions (\url{https://datatables.net/extensions/index})}

\item{plugins}{a character vector of the names of DataTables plug-ins
(\url{https://rstudio.github.io/DT/plugins.html}).  Note that only those
plugins supported by the \code{DT} package can be used here. You can see
the available plugins by calling \code{DT:::available_plugins()}}

\item{editable}{\code{FALSE} to disable the table editor, or \code{TRUE} (or
\code{"cell"}) to enable editing a single cell. Alternatively, you can set
it to \code{"row"} to be able to edit a row, or \code{"column"} to edit a
column, or \code{"all"} to edit all cells on the current page of the table.
In all modes, start editing by doubleclicking on a cell. This argument can
also be a list of the form \code{list(target = TARGET, disable =
list(columns = INDICES))}, where \code{TARGET} can be \code{"cell"},
\code{"row"}, \code{"column"}, or \code{"all"}, and \code{INDICES} is an
integer vector of column indices. Use the list form if you want to disable
editing certain columns. You can also restrict the editing to accept only
numbers by setting this argument to a list of the form \code{list(target =
TARGET, numeric = INDICES)} where \code{INDICES} can be the vector of the
indices of the columns for which you want to restrict the editing to
numbers or \code{"all"} to restrict the editing to numbers for all columns.
If you don't set \code{numeric}, then the editing is restricted to numbers
for all numeric columns; set \code{numeric = "none"} to disable this
behavior. It is also possible to edit the cells in text areas, which are
useful for large contents. For that, set the \code{editable} argument to a
list of the form \code{list(target = TARGET, area = INDICES)} where
\code{INDICES} can be the vector of the indices of the columns for which
you want the text areas, or \code{"all"} if you want the text areas for
all columns. Of course, you can request the numeric editing for some
columns and the text areas for some other columns by setting
\code{editable} to a list of the form \code{list(target = TARGET, numeric
= INDICES1, area = INDICES2)}. Finally, you can edit date cells with a
calendar with \code{list(target = TARGET, date = INDICES)}; the target
columns must have the \code{Date} type. If you don't set \code{date} in
the \code{editable} list, the editing with the calendar is automatically
set for all \code{Date} columns.}

\item{id}{\code{character(1)} module id}

\item{keys}{\code{character}. Defaults to all columns under the assumption that at least every row is unique.}

\item{in_place}{\code{logical}}

\item{format}{function accepting and returning a \code{\link[DT]{datatable}}}

\item{foreignTbls}{\code{list}. List of objects created by \code{\link{foreignTbl}}}

\item{statusColor}{named \code{character}. Colors to indicate status of the row.}

\item{inputUI}{\code{function}. UI function of a shiny module with at least arguments \code{id} \code{data} and \code{...}.}

\item{defaults}{expression that evaluates to a \code{tibble} with (a subset of) columns of the data.
It will be evaluated for each new row in the environment defined by 'env'.
This allows for defaults like Sys.time() or uuid::UUIDgenerate() as well as dynamic inputs.
elements with inputIds identical to one of the column names are used to update the data.}

\item{env}{\code{environment} in which the server function is running. Should normally not be modified.}
}
\value{
list
\itemize{
\item result \code{reactive} modified version of \code{data} (saved)
\item state \code{reactive} current state of the \code{data} (unsaved)
\item selected \code{reactive} selected rows of the \code{data} (unsaved)
}
}
\description{
Create a modifieable datatable.
}
\details{
Works the same as \code{\link[DT]{datatable}}.
This function is however a shiny module and comes with additional arguments and different defaults.
Instead of having \code{output$id = renderDT(DT::datatable(iris))}, \code{eDT(id = 'id', data = iris)} should be used on the server side.
On the UI side \code{\link{eDTOutput}} should be used instead of \code{\link[DT]{DTOutput}}.

Can also be used as standalone app when not ran in reactive context.

All arguments except 'id' and 'env' can be normal objects or reactive objects.
}
\examples{
## Only run this example in interactive R sessions
if(interactive()){
  # tibble support
  modifiedData <- editbl::eDT(tibble::as_tibble(mtcars))

  # data.table support
  modifiedData <- editbl::eDT(dtplyr::lazy_dt(data.table::data.table(mtcars)))

  # database support
  tmpFile <- tempfile(fileext = ".sqlite")
  file.copy(system.file("extdata", "chinook.sqlite", package = 'editbl'), tmpFile)

  conn <- editbl::connectDB(dbname = tmpFile)
  modifiedData <- editbl::eDT(dplyr::tbl(conn, "Artist"), in_place = TRUE)
  DBI::dbDisconnect(conn)

  unlink(tmpFile)

  # Within shiny
  library(shiny)
  library(editbl)
  shinyApp(
    ui = fluidPage(fluidRow(column(12, eDTOutput('tbl')))),
    server = function(input, output) {
      eDT('tbl',iris,)
    }
  )
}

}
\author{
Jasper Schelfhout
}
