% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destring.R
\name{makenum}
\alias{makenum}
\title{a function to convert numeric factors into numeric class objects}
\usage{
makenum(x)
}
\arguments{
\item{x}{a factor with numeric levels}
}
\value{
A numeric
}
\description{
This function allows you to convert directly from a numeric 
factor to the numeric class in R and strip away the underlying level index 
of a factor. This makes it safer to convert from factors to numeric characters 
directly without accidentally misassigning numbers.
}
\details{
This function should only be used on factors where all levels are 
valid numbers that can be coerced into a numeric class.
}
\note{
This will force all levels to be converted to characters and then to 
numeric objects. Leading zeroes will be stripped off and commas will 
cause errors.
}
\examples{
a <- ordered(c(1, 3, '09', 7, 5))
b <- makenum(a)
class(b)
b
a

}
\seealso{
\code{\link{character}}
}
\author{
Jared E. Knowles
}
