% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_d_to_common_language.R
\name{d_to_common_language}
\alias{d_to_common_language}
\alias{convert_d_to_common_language}
\title{Convert Standardized Mean Difference to Common Language Effect Sizes}
\usage{
d_to_common_language(d)

convert_d_to_common_language(d)
}
\arguments{
\item{d}{Standardized difference value (Cohen's d).}
}
\description{
Convert Standardized Mean Difference to Common Language Effect Sizes
}
\details{
This function use the following formulae:
\deqn{Cohen's U_3 = \Phi(d)}
\cr\cr
\deqn{Overlap = 2 \times \Phi(-|d|/2)}
\cr\cr
\deqn{Pr(superiority) = \Phi(d/\sqrt{2})}
}
\note{
These calculations assume that the populations have equal variance and are
normally distributed.
}
\references{
\itemize{
\item Cohen, J. (1977). Statistical power analysis for the behavioral sciencies. Routledge.
\item Reiser, B., & Faraggi, D. (1999). Confidence intervals for the overlapping coefficient: the normal equal variance case. Journal of the Royal Statistical Society, 48(3), 413-418.
\item Ruscio, J. (2008). A probability-based measure of effect size: robustness to base rates and other factors. Psychological methods, 13(1), 19–30.
}
}
\seealso{
\code{\link[=cohens_d]{cohens_d()}}
}
