% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_effectsizes.R
\name{rank_biserial}
\alias{rank_biserial}
\alias{cliffs_delta}
\alias{rank_epsilon_squared}
\alias{kendalls_w}
\title{Effect size for non-parametric (rank sum) tests}
\usage{
rank_biserial(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  iterations = 200,
  paired = FALSE,
  verbose = TRUE,
  ...
)

cliffs_delta(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  iterations = 200,
  verbose = TRUE,
  ...
)

rank_epsilon_squared(x, groups, data = NULL, ci = 0.95, iterations = 200, ...)

kendalls_w(x, groups, blocks, data = NULL, ci = 0.95, iterations = 200, ...)
}
\arguments{
\item{x}{Can be one of:
\itemize{
\item A numeric vector, or a character name of one in \code{data}.
\item A formula in to form of \code{x ~ groups} (for \code{rank_biserial()} and
\code{rank_epsilon_squared()}) or \code{x ~ groups | blocks} (for \code{kendalls_w()}).
\item A list of vectors (for \code{rank_epsilon_squared()}).
\item A matrix of \verb{blocks x groups} (for \code{kendalls_w()}).
}}

\item{y}{An optional numeric vector of data values to compare to \code{x}, or a
character name of one in \code{data}. Ignored if \code{x} is not a vector.}

\item{data}{An optional data frame containing the variables.}

\item{mu}{a number indicating the value around which (a-)symmetry (for
one-sample or paired samples) or shift (for independant samples) is to be
estimated. See \link[stats:wilcox.test]{stats::wilcox.test}.}

\item{ci}{Confidence Interval (CI) level}

\item{iterations}{The number of bootstrap replicates for computing confidence intervals. Only applies when \code{ci} is not \code{NULL}.}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods.}

\item{groups}{A vector or factor object giving the group for the
corresponding elements of \code{x}, or a character name of one in \code{data}.
Ignored if \code{x} is not a vector.}

\item{blocks}{A vector giving the block for the corresponding elements of
\code{x}, or a character name of one in \code{data}. Ignored if \code{x} is not a vector.}
}
\value{
A data frame with the effect size (\code{r_rank_biserial}, \code{Kendalls_W} or
\code{rank_epsilon_squared}) and its CI (\code{CI_low} and \code{CI_high}).
}
\description{
Compute the rank-biserial correlation, Cliff's \emph{delta}, rank Epsilon squared,
and Kendall's \emph{W} effect sizes for non-parametric (rank sum) tests.
}
\details{
Compute effect sizes for non-parametric (rank sum) tests.
\cr\cr
The rank-biserial correlation is appropriate for non-parametric tests of
differences - both for the one sample or paired samples case, that would
normally be tested with Wilcoxon's Signed Rank Test (giving the
\strong{matched-pairs} rank-biserial correlation) and for two independent samples
case, that would normally be tested with Mann-Whitney's \emph{U} Test (giving
\strong{Glass'} rank-biserial correlation). See \link[stats:wilcox.test]{stats::wilcox.test}. In both
cases, the correlation represents the difference between the proportion of
favorable and unfavorable pairs / signed ranks (Kerby, 2014). Values range
from \code{-1} indicating that all values of the second sample are smaller than
the first sample, to \code{+1} indicating that all values of the second sample are
larger than the first sample. (Cliff's \emph{delta} is an alias to the
rank-biserial correlation in the two sample case.)
\cr\cr
The rank Epsilon squared is appropriate for non-parametric tests of
differences between 2 or more samples (a rank based ANOVA). See
\link[stats:kruskal.test]{stats::kruskal.test}. Values range from 0 to 1, with larger values
indicating larger differences between groups.
\cr\cr
Kendall's \emph{W} is appropriate for non-parametric tests of differences between
2 or more dependant samples (a rank based rmANOVA). See
\link[stats:friedman.test]{stats::friedman.test}. Values range from 0 to 1, with larger values
indicating larger differences between groups.
}
\section{Confidence Intervals}{
Confidence Intervals are estimated using the bootstrap method.
}

\examples{
\donttest{
A <- c(48, 48, 77, 86, 85, 85)
B <- c(14, 34, 34, 77)
rank_biserial(A, B)

x <- c(1.83,  0.50,  1.62,  2.48, 1.68, 1.88, 1.55, 3.06, 1.30)
y <- c(0.878, 0.647, 0.598, 2.05, 1.06, 1.29, 1.06, 3.14, 1.29)
rank_biserial(x, y, paired = TRUE)

x <- c(1.15, 0.88, 0.90, 0.74, 1.21)
rank_biserial(x, mu = 1)

x1 <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
x2 <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
x3 <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis
x <- c(x1, x2, x3)
g <- factor(rep(1:3, c(5, 4, 5)))
rank_epsilon_squared(x, g)

wb <- aggregate(warpbreaks$breaks,
                by = list(w = warpbreaks$wool,
                          t = warpbreaks$tension),
                FUN = mean)
kendalls_w(x ~ w | t, data = wb)
}

}
\references{
\itemize{
\item Cureton, E. E. (1956). Rank-biserial correlation. Psychometrika, 21(3), 287-290.
\item Glass, G. V. (1965). A ranking variable analogue of biserial correlation: Implications for short-cut item analysis. Journal of Educational Measurement, 2(1), 91-95.
\item Kendall, M.G. (1948) Rank correlation methods. London: Griffin.
\item Kerby, D. S. (2014). The simple difference formula: An approach to teaching nonparametric correlation. Comprehensive Psychology, 3, 11-IT.
\item King, B. M., & Minium, E. W. (2008). Statistical reasoning in the behavioral sciences. John Wiley & Sons Inc.
\item Cliff, N. (1993). Dominance statistics: Ordinal analyses to answer ordinal questions. Psychological bulletin, 114(3), 494.
\item Tomczak, M., & Tomczak, E. (2014). The need to report effect size estimates revisited. An overview of some recommended measures of effect size.
}
}
\seealso{
Other effect size indices: 
\code{\link{cohens_d}()},
\code{\link{effectsize}()},
\code{\link{eta_squared}()},
\code{\link{phi}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
