% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_preprocessing.R
\name{stdize_votes}
\alias{stdize_votes}
\title{stdize_votes}
\usage{
stdize_votes(
  data,
  cols,
  totals_col = NULL,
  max_dev = 0.1,
  avg_dev = 0.025,
  new_names = FALSE,
  verbose = TRUE,
  diagnostic = FALSE
)
}
\arguments{
\item{data}{A dataframe of election results, where each row represents a
precinct or geographic voting unit}

\item{cols}{A character vector with the names of the columns indicating total
votes cast by each race, or for each candidate}

\item{totals_col}{A character string with the name of the total vote count
column in the data. If null, total votes are computed within the function}

\item{max_dev}{A numeric object setting the max allowable deviation of a
precinct's vote sum from totals}

\item{avg_dev}{A numeric object setting the max allowable average deviation
difference of all precints' vote sums from totals}

\item{new_names}{A boolean indicating whether to return cand and race columns
with the same names. If FALSE, names returned with "_prop" added on.}

\item{verbose}{A boolean indicating whether to print status messages}

\item{diagnostic}{A boolean. When true, an extra column of booleans is
returned indicating whether each row had a deviation from totals}
}
\value{
A dataframe with proportions corresponding to the turnout of each
race/ethnicity group
}
\description{
Converts raw vote totals from different voter groups /
candidates across precincts into proportions, checking
for problematic differences between known vote totals
and sums across race/ethnicities.
}
\details{
If turnout columns sum row-wise to equal vote_totals, they are
returned as proportions.

If turnout columns sum row-wise to sufficiently close to
vote_totals, they are returned as proportions of the sums.

If turnout columns sum row-wise exceedingly far from
vote_totals, the function stops and returns an error message.
}
\author{
Ari Decter-Frain
}
