% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoset.R
\name{eia_geoset}
\alias{eia_geoset}
\title{EIA geoset data}
\usage{
eia_geoset(id, region, relation = NULL, start = NULL, end = NULL,
  n = NULL, tidy = TRUE, cache = TRUE, key = eia_get_key())
}
\arguments{
\item{id}{character, geoset series ID, may be a vector. See details.}

\item{region}{character, region ID, may be a vector. Data available for the intersection of \code{id} and \code{region} is returned.}

\item{relation}{logical, make a geoset relation query instead of a geoset query. The series \code{id} is the same but is queried differently. Currently not supported, see details.}

\item{start}{start date. Providing only a start date will return up to the maximum 100 results if available.}

\item{end}{end date. Providing only an end date will a single result for that date.}

\item{n}{integer, length of series to return ending at most recent value or at \code{end} date if also provided. Ignored if \code{start} is not \code{NULL}.}

\item{tidy}{logical, return a tidier result. See details.}

\item{cache}{logical, cache result for duration of R session using memoization. See details.}

\item{key}{API key: character if set explicitly; not needed if key is set globally. See \code{\link{eia_set_key}}.}
}
\value{
a tibble data frame (or a list, or character, depending on \code{tidy} value)
}
\description{
Obtain EIA geoset data.
}
\details{
\code{id} may be a vector. This should only be done with \code{tidy = TRUE} if the tidied results can be properly row bound.
The geoset API calls allow multiple regions, but the API expects a single series ID.
This function allows multiple series, but must make one API call per series ID.
There is an expectation of similarly formatted series that can be row bound.
If the IDs are for differently structured data that cannot be tidily row bound,
you may as well make separate requests since each requires a unique API call either way.

By default, additional processing is done to return a tibble data frame.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.

Set to \code{cache = FALSE} to force a new API call for updated data.
Using \code{FALSE} always makes a new API call and returns the result from the server.
\code{TRUE} uses memoization on a per R session basis, caching the result of the function call in memory for the duration of the R session.
You can reset the entire cache by calling \code{eia_clear_cache()}.

The EIA \code{relation} API endpoint is officially supported according to the online EIA API documentation, but that endpoint does not appear to function at the time of current package release.
}
\examples{
\dontrun{
# use eia_set_key() to store stored API key
id <- paste0("ELEC.GEN.ALL-99.", c("A", "Q", "M"))
region <- c("USA-CA", "USA-NY")

eia_geoset(id[1], region[1], start = 2016)
eia_geoset(id[2], region, n = 5)
eia_geoset(id[3], region[2], end = 2016, n = 5)

# multiple series counted as a single API call
x <- eia_geoset(id, region[1], end = 2016, n = 2)
x[, c("region", "data")]

# Use direct US state abbreviations or names;
# Use US Census region and division names.
x <- eia_geoset(id[2], c("AK", "New England"), end = 2016, n = 1)
x[, c("region", "data")]
}
}
\seealso{
\code{\link{eia_clear_cache}}
}
