% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{eiadate}
\alias{eiadate}
\alias{eiadate_to_date}
\alias{date_to_eiadate}
\alias{eiadate_to_date_seq}
\title{EIA date parsing}
\usage{
eiadate_to_date(x)

date_to_eiadate(x, date_format = c("A", "Q", "M", "W", "D", "H"))

eiadate_to_date_seq(start, end, weekly = FALSE)
}
\arguments{
\item{x}{character, EIA date string; character or date object for regular dates. See details.}

\item{date_format}{EIA date format: "A", "Q", "M", "W", "D", "H".
These stand for annual, quarterly, monthly, weekly, daily, hourly. See details.}

\item{start}{start EIA date or date.}

\item{end}{end EIA date or date.}

\item{weekly}{logical. See details.}
}
\description{
Helper functions for manipulating and converting between regular year-month-day date strings and EIA date string notation.
}
\details{
There is no reason to mix EIA date formats in this context. Functions that take EIA date strings expect a consistent format.
Also, EIA date formats are parsed automatically from the dates themselves.
However, daily and weekly use the same format. Too avoid ambiguity in \code{eia_date_seq}, daily is assumed; set \code{weekly = TRUE} to treat as weekly.

When providing a real date or date string, such as to \code{date_to_eiadate}, dates should be in \code{yyyy-mm-dd} format,
or at least any format that can be parsed by \code{lubridate::ymd} or \code{lubridate::ymd_hms} for dates and hourly date times, respectively.

\code{"HL"} is not a supported date format. Use \code{"H"}. The API does not
translate the date and time when using \code{"HL"} anyhow; it simply appends
the date string with the number of hours time difference.
}
\examples{
eiadate_to_date(c("201803", "201804"))

date_to_eiadate("2018-05-14", "A")
date_to_eiadate("2018-05-14", "Q")
date_to_eiadate("2018-05-14", "M")

(x <- eiadate_to_date_seq("2018Q1", "2018Q4"))
date_to_eiadate(x, "Q")

(x <- eiadate_to_date("20190102T16Z"))
date_to_eiadate(x, "H")
(x <- eiadate_to_date_seq("20190102T16Z", "20190102T19Z"))
date_to_eiadate(x, "H")
}
