% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_profile.R
\name{wrf_profile}
\alias{wrf_profile}
\title{Create a spatial profile from a wrf emission file and a data frame with}
\format{a numeric vector}
\usage{
wrf_profile(x, file, adjust = 0, verbose = T)
}
\arguments{
\item{x}{data.frame of intenticy of traffic by hours (rows) and weekdays
(columns)}

\item{file}{emission file name}

\item{adjust}{numer of hours to advance (positive value) or delay (negative value)}

\item{verbose}{display additional information}
}
\description{
returns a traffic intensity profile (based on wrf file Times)
and a traffic intensity data frame
}
\note{
It might be deprecatedin future release
}
\examples{
\dontrun{
# Do not run

# Profile based on Sao Paulo tunnel experiments
data(rawprofile)
rawprofile  <- matrix(rawprofile, nrow = 24, byrow = TRUE)
rawprofile <- as.data.frame(rawprofile)
names(rawprofile) <- c("Sunday","Monday","Tuesday","Wednesday","Thursday",
                       "Friday","Saturday")
row.names(rawprofile) <- c("00:00","01:00","02:00","03:00","04:00","05:00",
                           "06:00","07:00","08:00","09:00","10:00","11:00",
                           "12:00","13:00","14:00","15:00","16:00","17:00",
                           "18:00","19:00","20:00","21:00","22:00","23:00")

print(rawprofile)

# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
          wrfchemi_dir = file.path(tempdir(), "EMISS"),
          frames_per_auxinput5 = 24)

files <- list.files(path = file.path(tempdir(), "EMISS"),
                    pattern = "wrfchemi",
                    full.names = TRUE)

profile <- wrf_profile(rawprofile,files[1])

plot(profile, ty="l", lty = 2, axe = FALSE,
     main = "Traffic Intensity for Sao Paulo", xlab = "hour")
axis(2)
axis(1, at = 0.5 + c(0, 6, 12, 18, 24),
    labels = c("00:00","06:00","12:00","18:00", "00:00"))
}
}
\seealso{
\code{\link{wrf_create}} and \code{\link{to_wrf}}
}
\author{
Daniel Schuch
}
