% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmark}
\alias{benchmark}
\title{Run benchmark tests}
\usage{
benchmark(raw = FALSE, callopts = list(), query = list(), ...)
}
\arguments{
\item{raw}{(logical) If TRUE (default), data is parsed to list. If FALSE, then raw JSON.}

\item{callopts}{Curl args passed on to httr::POST.}

\item{query}{Query, either a list or json.}

\item{...}{Further args passed on to elastic search HTTP API as parameters. Not used right now.}
}
\description{
THIS FUNCTION DOESN'T WORK YET.
}
\examples{
\dontrun{
# pass in as an R list
args <- list(name = "b1",
   competitors = list(name = "c1", requests = list(query = list(match = "a*"))))
benchmark(index="shakespeare", query=args)

# or pass in as json query with newlines, easy to read
aggs <- '{
"name": "b1",
"competitors": [ {
"name": "c1",
  "requests": [ {
    "query": {
      "match": { "_all": "a*" }
    }
  } ]
} ]
}'
benchmark(query=aggs)

# or pass in collapsed json string
aggs <- '{"aggs":{"stats":{"terms":{"field":"text_entry"}}}}'
es_search_body(index="shakespeare", query=aggs)

# match query
match <- '{"query": {"match" : {"text_entry" : "Two Gentlemen"}}}'
es_search_body(index="shakespeare", query=match)

# multi-match (multiple fields that is) query
mmatch <- '{"query": {"multi_match" : {"query" : "henry","fields":["text_entry","play_name"]}}}'
es_search_body(index="shakespeare", query=mmatch)

# bool query
mmatch <- '{
 "query": {
   "bool" : {
     "must_not" : {
       "range" : {
         "speech_number" : {
           "from" : 1, "to": 5
}}}}}}'
}
}
\references{
\url{http://www.elasticsearch.org/guide/en/elasticsearch/reference/master/search-benchmark.html}
}
\keyword{internal}

