% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msearch.R
\name{msearch}
\alias{msearch}
\title{Multi-search}
\usage{
msearch(x, raw = FALSE, asdf = FALSE, ...)
}
\arguments{
\item{x}{(character) A file path}

\item{raw}{(logical) Get raw JSON back or not.}

\item{asdf}{(logical) If \code{TRUE}, use \code{\link[jsonlite]{fromJSON}} to parse JSON
directly to a data.frame. If \code{FALSE} (Default), list output is given.}

\item{...}{Curl args passed on to \code{\link[httr]{POST}}}
}
\description{
Performs multiple searches, defined in a file
}
\details{
This function behaves similarly to \code{\link{docs_bulk}} - performs
searches based on queries defined in a file.
}
\examples{
\dontrun{
connect()
msearch1 <- system.file("examples", "msearch_eg1.json", package = "elastic")
readLines(msearch1)
msearch(msearch1)

cat('{"index" : "shakespeare"}', file = "~/mysearch.json", sep = "\\n")
cat('{"query" : {"match_all" : {}}, "from" : 0, "size" : 5}',  sep = "\\n",
   file = "~/mysearch.json", append = TRUE)
msearch("~/mysearch.json")
}
}
\seealso{
\code{\link{Search_uri}} \code{\link{Search}}
}

