% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ingest.R
\name{ingest}
\alias{ingest}
\alias{pipeline_create}
\alias{pipeline_attachment}
\alias{pipeline_get}
\alias{pipeline_delete}
\alias{pipeline_simulate}
\title{Ingest API operations}
\usage{
pipeline_create(conn, id, body, ...)

pipeline_attachment(conn, index, id, pipeline, body, type = NULL, ...)

pipeline_get(conn, id, filter_path = NULL, ...)

pipeline_delete(conn, id, body, ...)

pipeline_simulate(conn, body, id = NULL, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{id}{(character) one or more pipeline id's. with delete, you can use
a wildcard match}

\item{body}{body describing pipeline, see examples and Elasticsearch docs}

\item{...}{Curl args passed on to \link[crul:verb-POST]{crul::verb-POST}, \link[crul:verb-GET]{crul::verb-GET},
\link[crul:verb-PUT]{crul::verb-PUT}, or \link[crul:verb-DELETE]{crul::verb-DELETE}}

\item{index}{(character) an index. only used in \code{pipeline_attachment}}

\item{pipeline}{(character) a pipeline name. only used in \code{pipeline_attachment}}

\item{type}{(character) a type. only used in \code{pipeline_attachment}. by default
ths is set to \code{NULL} - optional in ES <= v6.3; not allowed in ES >= v6.4}

\item{filter_path}{(character) fields to return. deafults to all if not given}
}
\value{
a named list
}
\description{
Ingest API operations
}
\details{
ingest/pipeline functions available in Elasticsearch v5 and
greater
}
\section{Attachments}{

See https://www.elastic.co/guide/en/elasticsearch/plugins/current/ingest-attachment.html
You need to install the attachment processor plugin to be able to use
attachments in pipelines
}

\examples{
\dontrun{
# connection setup
(x <- connect())

# create
body1 <- '{
  "description" : "do a thing",
  "version" : 123,
  "processors" : [
    {
      "set" : {
        "field": "foo",
        "value": "bar"
      }
    }
  ]
}'
body2 <- '{
  "description" : "do another thing",
  "processors" : [
    {
      "set" : {
        "field": "stuff",
        "value": "things"
      }
    }
  ]
}'
pipeline_create(x, id = 'foo', body = body1)
pipeline_create(x, id = 'bar', body = body2)

# get
pipeline_get(x, id = 'foo')
pipeline_get(x, id = 'bar')
pipeline_get(x, id = 'foo', filter_path = "*.version")
pipeline_get(x, id = c('foo', 'bar')) # get >1

# delete
pipeline_delete(x, id = 'foo')

# simulate
## with pipeline included
body <- '{
  "pipeline" : {
    "description" : "do another thing",
    "processors" : [
      {
        "set" : {
          "field": "stuff",
          "value": "things"
        }
      }
    ]
  },
  "docs" : [
    { "_source": {"foo": "bar"} },
    { "_source": {"foo": "world"} }
  ]
}'
pipeline_simulate(x, body)

## referencing existing pipeline
body <- '{
  "docs" : [
    { "_source": {"foo": "bar"} },
    { "_source": {"foo": "world"} }
  ]
}'
pipeline_simulate(x, body, id = "foo")

# attchments - Note: you need the attachment plugin for this, see above
body1 <- '{
  "description" : "do a thing",
  "version" : 123,
  "processors" : [
    {
      "attachment" : {
        "field" : "data"
      }
    }
  ]
}'
pipeline_create(x, "baz", body1)
body_attach <- '{
  "data": "e1xydGYxXGFuc2kNCkxvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0DQpccGFyIH0="
}'
if (!index_exists(x, "boomarang")) index_create(x, "boomarang")
docs_create(x, 'boomarang', id = 1, body = list(title = "New title"))
pipeline_attachment(x, "boomarang", "1", "baz", body_attach)
pipeline_get(x, id = 'baz')
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/ingest-apis.html},
\url{https://www.elastic.co/guide/en/elasticsearch/plugins/current/using-ingest-attachment.html}
}
