% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{\%create\%}
\alias{\%create\%}
\title{Create Elasticsearch index with custom mapping.}
\usage{
rescource \%create\% mapping
}
\arguments{
\item{rescource}{An \code{elastic_rescource} object that contains the information on the
Elasticsearch cluster, index and document type, where the indexed data will reside. If this does
not already exist, it will be created automatically.}

\item{mapping}{A JSON object containing the mapping details required for the index.}
}
\description{
Mappings are the closest concept to traditional database 'schema'. This function allows the
creation of Elasticsearch indicies with custom mappings. If left unspecified, Elasticsearch will
infer the type of each field based on the first document indexed.
}
\examples{
\dontrun{
elastic("http://localhost:9200", "iris", "data") \%create\% mapping_default_simple()
}
}
\seealso{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping.html}
}
