\name{do.audit}
\alias{do.audit}

\title{ do.audit }
\description{
Given a list of precincts to audit, the truth (as an elec.data object),
and the original votes (also as an elec.data object), do
a simulated CAST audit and return the audit frame as a result.

}
\usage{
do.audit(Z, truth, audit.names, ns = NULL)
}

\arguments{
  \item{Z}{ elec.data object }
  \item{truth}{ another elec.data object--this one's vote counts are
  considered "true" }
  \item{audit.names}{ name of precincts to audit.  Correspond to
  rownames of the Z and truth elec.data objects. }
  \item{ns}{ List of sample sizes for strata. If this is passed, this method will randomly select the precincts to
  audit.  In this case audit.names should be set to NULL. }
}
\details{
Given the reported vote table, Z, and the actual truth (simulated)
 (a Z matrix with same precincts), and a list of precincts to audit,
 do the audit.  If audit.names
 is null and the ns is not null, it will sample from precincts via
 CAST.sample automatically.

}
\value{
  Overstatments for each candidate for each precinct.
}
\examples{
Z = make.cartoon(n=200)
truth = make.truth.opt.bad(Z, t=0, bound="WPM")
samp.info=CAST.calc.sample(Z, beta=0.75, stages=1, t=5 )
audit.names = CAST.sample( Z, samp.info )
do.audit( Z, truth, audit.names )

}

\seealso{
  \link{CAST} for how to run the CAST auditing method.
  See \code{\link{make.sample}} and
  \code{\link{make.truth}} for generating fake situations for doing
  simulation studies of the CAST method.
  See \link{AuditErrors} and \code{\link{audit.totals.to.OS}} for utility functions handing processing of
  audit data.
}

\author{ Luke W. Miratrix }


