% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\docType{class}
\name{dirtree}
\alias{dirtree}
\alias{dtree}
\title{Create a Dirichlet-tree object}
\usage{
dirtree(
  candidates,
  min_depth = 0,
  max_depth = length(candidates),
  a0 = 1,
  vd = FALSE
)
}
\arguments{
\item{candidates}{A character vector, with each element (must be unique) representing a single
candidate.}

\item{min_depth}{The minimum number of candidates which must be specified for a valid ballot.}

\item{max_depth}{The maximum number of candidates which can be specified for a valid ballot.}

\item{a0}{The prior parameter for the distribution.}

\item{vd}{A flag which, when \code{TRUE}, employs a parameter structure which reduces
to a regular Dirichlet distribution as described by
\insertCite{dtree_evoteid;textual}{elections.dtree}.}
}
\value{
A Dirichlet-tree representing ranked ballots, as an object of class
\code{dirichlet_tree}.
}
\description{
\code{dirtree} is used to create a Dirichlet-tree for modelling ballots,
as described by \insertCite{dtree_evoteid;textual}{elections.dtree}.
}
\references{
\insertRef{dtree_eis}{elections.dtree}.

\insertRef{dtree_evoteid}{elections.dtree}.
}
\keyword{ballot}
\keyword{dirichlet}
\keyword{dirichlet-tree}
\keyword{election}
\keyword{irv}
\keyword{tree}
